# 画面設計書 50-kubeadm certs

## 概要

本ドキュメントは、kubeadmのcertsコマンドの画面設計書である。Kubernetesクラスタ内のTLS証明書の更新、有効期限確認、証明書キー生成、CSR生成を管理するCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：KubernetesクラスタのコントロールプレーンコンポーネントはTLS証明書による相互認証を行う。証明書には有効期限があり（デフォルト1年）、定期的な更新が必要である。certsコマンドは証明書のライフサイクル管理を提供し、クラスタの安全な運用を支援する。また、外部CAモードでのCSR生成にも対応する。

**画面へのアクセス方法**：ターミナルから `kubeadm certs SUBCOMMAND [flags]` を実行する。エイリアス `kubeadm certificates` も使用可能。

**主要な操作・処理内容**：
1. `kubeadm certs renew <cert-name|all>` - 指定した証明書またはすべての証明書を更新する
2. `kubeadm certs check-expiration` - 全証明書の有効期限を確認する
3. `kubeadm certs certificate-key` - 証明書暗号化キーを生成する
4. `kubeadm certs generate-csr` - CSR（証明書署名リクエスト）とキーペアを生成する

**画面遷移**：certs renewはkubeadm upgradeの前後で使用される。generate-csrは外部CAモードでkubeadm initの代わりに使用される。

**権限による表示制御**：証明書ファイルへの読み書きアクセスが必要。check-expirationは読み取りのみ。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 121 | 証明書管理 | 主機能 | クラスター内の各種TLS証明書の生成、ローテーション、管理を行う主処理 |

## 画面種別

管理操作（CLIサブコマンド構造）

## URL/ルーティング

```
kubeadm certs renew <cert-name|all> [flags]
kubeadm certs check-expiration [flags]
kubeadm certs certificate-key
kubeadm certs generate-csr [flags]
```

エイリアス: `kubeadm certificates`

## 入出力項目

### 入力項目（renew サブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| <cert-name> | string | 必須 | - | 更新する証明書名（例: apiserver, all） |
| --config | string | 任意 | "" | 設定ファイルパス |
| --cert-dir | string | 任意 | /etc/kubernetes/pki | 証明書ディレクトリ |
| --kubeconfig | string | 任意 | /etc/kubernetes/admin.conf | kubeconfigファイルパス |

### 入力項目（check-expiration サブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --config | string | 任意 | "" | 設定ファイルパス |
| --cert-dir | string | 任意 | /etc/kubernetes/pki | 証明書ディレクトリ |
| --kubeconfig | string | 任意 | /etc/kubernetes/admin.conf | kubeconfigファイルパス |
| -o, --output | string | 任意 | text | 出力形式（text/json/yaml） |

### 入力項目（generate-csr サブコマンド）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --config | string | 任意 | "" | 設定ファイルパス |
| --cert-dir | string | 任意 | "" | CSR出力先ディレクトリ |
| --kubeconfig-dir | string | 任意 | /etc/kubernetes | kubeconfig出力先ディレクトリ |

### 出力項目

| サブコマンド | 出力内容 |
|-------------|---------|
| renew | 更新結果メッセージ |
| check-expiration | 証明書有効期限テーブル |
| certificate-key | 生成された証明書キー |
| generate-csr | CSRファイル生成結果 |

## 表示項目

check-expiration出力例：
```
CERTIFICATE                EXPIRES                  RESIDUAL TIME   CERTIFICATE AUTHORITY   EXTERNALLY MANAGED
admin.conf                 Jan 02, 2026 15:04 MST   364d            ca                      no
apiserver                  Jan 02, 2026 15:04 MST   364d            ca                      no
apiserver-etcd-client      Jan 02, 2026 15:04 MST   364d            etcd-ca                 no
...

CERTIFICATE AUTHORITY      EXPIRES                  RESIDUAL TIME   EXTERNALLY MANAGED
ca                         Jan 01, 2035 15:04 MST   10y             no
etcd-ca                    Jan 01, 2035 15:04 MST   10y             no
front-proxy-ca             Jan 01, 2035 15:04 MST   10y             no
```

renew出力例：
```
certificate embedded in /etc/kubernetes/admin.conf renewed
certificate for serving the Kubernetes API renewed
```

## イベント仕様

### 1-renew実行

1. クラスタ設定の取得（--config、ConfigMap、またはデフォルト）
2. `renewal.NewManager()` で更新マネージャを作成
3. 証明書の存在確認
4. `rm.RenewUsingLocalCA()` でローカルCAを使用して証明書を更新
5. 外部CAの場合は更新不可のメッセージを表示

### 2-check-expiration実行

1. クラスタ設定の取得
2. `renewal.NewManager()` で更新マネージャを作成
3. 全証明書とCA証明書の有効期限情報を収集
4. テーブル形式（またはJSON/YAML）で出力

### 3-certificate-key実行

1. `copycerts.CreateCertificateKey()` でランダムキーを生成
2. 標準出力に出力

### 4-generate-csr実行

1. 設定のロード
2. `certsphase.CreateDefaultKeysAndCSRFiles()` でキーとCSRを生成
3. `kubeconfigphase.CreateDefaultKubeConfigsAndCSRFiles()` でkubeconfig用CSRを生成

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| renew | ファイルシステム(証明書ファイル) | UPDATE | 証明書ファイルの更新 |
| check-expiration | ファイルシステム(証明書ファイル) | SELECT | 証明書ファイルの読み取り |
| certificate-key | なし | なし | ローカルでのキー生成のみ |
| generate-csr | ファイルシステム(CSR/キーファイル) | CREATE | CSRとキーファイルの生成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| INFO-01 | 情報 | `%s renewed` | 証明書更新成功時 |
| INFO-02 | 情報 | `Done renewing certificates. You must restart...` | renew all完了時 |
| INFO-03 | 情報 | `MISSING! %s` | 証明書ファイルが存在しない場合 |
| INFO-04 | 情報 | `Detected external %s, %s can't be renewed` | 外部CAで更新不可の場合 |

## 例外処理

- 証明書ファイルが存在しない場合は "MISSING!" と表示して続行（check-expiration）
- 外部CA検出時は更新不可メッセージを表示して続行（renew）
- クラスタ設定の取得に失敗した場合はデフォルト設定にフォールバック
- --cert-dirフラグはクラスタ設定の値をオーバーライドする

## 備考

- `certificates` がエイリアスとして使用可能
- renew allは全証明書を更新するが、更新後はkube-apiserver, kube-controller-manager, kube-scheduler, etcdの再起動が必要
- 更新はローカルCA（PKI）を使用し、有効期限に関係なく無条件で実行される
- check-expirationはテキスト以外にJSON/YAML出力にも対応
- generate-csrは外部CAモード用で、CSRを外部認証局に送信して署名を受ける運用フロー向け
- cert-dirフラグがクラスタから取得した値よりも優先される（行359-362）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | certs.go | `cmd/kubeadm/app/cmd/certs.go` | renewFlags構造体（行227-231）とexpirationFlags構造体（行479-483）を理解する |
| 1-2 | certs.go | `cmd/kubeadm/app/cmd/certs.go` | genCSRConfig構造体（行120-125）でCSR生成の設定を理解する |

**読解のコツ**: renewal.Manager がrenewalとexpirationの中心的なクラス。CertificateRenewHandlerが個々の証明書を管理する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | certs.go | `cmd/kubeadm/app/cmd/certs.go` | newCmdCertsUtility関数（行104-117）で4サブコマンドを登録。エイリアス "certificates" に注目（行107） |

**主要処理フロー**:
1. **行112**: renewサブコマンド追加
2. **行113**: check-expirationサブコマンド追加
3. **行114**: certificate-keyサブコマンド追加
4. **行115**: generate-csrサブコマンド追加

#### Step 3: renew処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | certs.go | `cmd/kubeadm/app/cmd/certs.go` | getRenewSubCommands（行233-312）で全証明書のrenewサブコマンドを動的生成。renewCert（行320-344）が個別証明書の更新を実行 |

#### Step 4: check-expiration処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | certs.go | `cmd/kubeadm/app/cmd/certs.go` | newCmdCertsExpiration（行430-477）とfetchCertificateExpirationInfo（行376-423）で有効期限情報の収集と出力を理解 |

#### Step 5: generate-csr処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | certs.go | `cmd/kubeadm/app/cmd/certs.go` | newCmdGenCSR（行164-182）とrunGenCSR（行185-193）で、certsphase.CreateDefaultKeysAndCSRFilesとkubeconfigphase.CreateDefaultKubeConfigsAndCSRFilesの2段階処理を理解 |

### プログラム呼び出し階層図

```
newCmdCertsUtility (certs.go:104)
    |
    +-- newCmdCertsRenewal (certs.go:215)
    |       +-- renew <cert-name>
    |       |       +-- getInternalCfg()
    |       |       +-- renewCert()
    |       |               +-- renewal.NewManager()
    |       |               +-- rm.RenewUsingLocalCA()
    |       +-- renew all
    |               +-- 全証明書について renewCert()
    |
    +-- newCmdCertsExpiration (certs.go:430)
    |       +-- getInternalCfg()
    |       +-- renewal.NewManager()
    |       +-- fetchCertificateExpirationInfo()
    |       +-- printer.PrintObj()
    |
    +-- newCmdCertificateKey (certs.go:196)
    |       +-- copycerts.CreateCertificateKey()
    |
    +-- newCmdGenCSR (certs.go:164)
            +-- genCSRConfig.load()
            +-- certsphase.CreateDefaultKeysAndCSRFiles()
            +-- kubeconfigphase.CreateDefaultKubeConfigsAndCSRFiles()
```

### データフロー図

```
[入力]                    [処理]                    [出力]

renew:
  証明書ファイル ──> renewal.Manager ──────────> 更新済み証明書ファイル
  クラスタ設定       rm.RenewUsingLocalCA()

check-expiration:
  証明書ファイル ──> renewal.Manager ──────────> stdout (テーブル/JSON)
                    GetCertificateExpirationInfo()

certificate-key:
  (なし) ──────────> copycerts.CreateCertificateKey() ──> stdout (キー)

generate-csr:
  設定 ────────────> CreateDefaultKeysAndCSRFiles() ──> CSR/キーファイル
                    CreateDefaultKubeConfigsAndCSRFiles()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| certs.go | `cmd/kubeadm/app/cmd/certs.go` | ソース | certsコマンド本体の実装 |
| renewal/ | `cmd/kubeadm/app/phases/certs/renewal/` | ソース | 証明書更新マネージャの実装 |
| certs/ | `cmd/kubeadm/app/phases/certs/` | ソース | 証明書生成フェーズの実装 |
| copycerts/ | `cmd/kubeadm/app/phases/copycerts/` | ソース | 証明書キー生成ユーティリティ |
| kubeconfig/ | `cmd/kubeadm/app/phases/kubeconfig/` | ソース | kubeconfig用CSR生成 |
| output/v1alpha3/ | `cmd/kubeadm/app/apis/output/v1alpha3/` | ソース | CertificateExpirationInfo出力型 |
